/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigTreeNode;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWSessionInfo;
import javax.swing.ImageIcon;

public class VWConfigAppSpaceNode
extends VWConfigBaseNode
implements IVWConfigTreeNode {
    private static final ImageIcon NODE_ICON_32 = VWImageLoader.createImageIcon("appspace_32.gif");
    private static final ImageIcon NODE_ICON_16 = VWImageLoader.createImageIcon("appspace_16.gif");
    private VWApplicationSpaceDefinition m_appSpaceDef = null;
    private VWSystemConfiguration m_sysConfig = null;

    public VWConfigAppSpaceNode(VWSessionInfo sessionInfo, VWApplicationSpaceDefinition appSpaceDef, String serviceName, int nRegionID, VWSystemConfiguration sysConfig) {
        super(appSpaceDef.getName(), 6, VWConfigActionCommand.ACMD_APPSPACE);
        this.m_sessionInfo = sessionInfo;
        this.m_appSpaceDef = appSpaceDef;
        this.m_serviceName = serviceName;
        this.m_regionID = nRegionID;
        this.m_sysConfig = sysConfig;
        this.m_description = appSpaceDef.getDescription();
        this.setIcon32(NODE_ICON_32);
        this.setIcon16(NODE_ICON_16);
    }

    public Object clone() {
        VWConfigAppSpaceNode appSpaceNode = (VWConfigAppSpaceNode)super.clone();
        appSpaceNode.m_sessionInfo = this.m_sessionInfo;
        appSpaceNode.m_appSpaceDef = (VWApplicationSpaceDefinition)this.m_appSpaceDef.clone();
        appSpaceNode.m_sysConfig = this.m_sysConfig;
        return appSpaceNode;
    }

    public VWSystemConfiguration getSystemConfiguration() {
        return this.m_sysConfig;
    }

    public void releaseResources() {
        this.m_sessionInfo = null;
        this.m_appSpaceDef = null;
        this.m_sysConfig = null;
        super.releaseResources();
    }

    public void selectExportComponents() {
        try {
            VWClassFactory.VWApplicationSpaceDefinition_setIsSelectedForExport(this.m_appSpaceDef, this.m_exportOpt == 2, 234L);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWApplicationSpaceDefinition getDefinition() {
        if (this.m_appSpaceDef != null) {
            return (VWApplicationSpaceDefinition)this.m_appSpaceDef.clone();
        }
        return null;
    }

    protected void setDefinition(VWApplicationSpaceDefinition newAppSpaceDef) {
        try {
            if (this.m_sysConfig != null && newAppSpaceDef != null) {
                this.m_sysConfig.updateApplicationSpaceDefinition(newAppSpaceDef);
                this.m_appSpaceDef = newAppSpaceDef;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

